#include<stdio.h>
#include<stdlib.h>
#include<string.h>

/* http://www.devtal.de/~thoto/ckurs/addressbuch2.tar.gz */

struct adresse{ /* Struktur aller Adressen: "Karteikarte" */
	char* vorname;
	char* name;

	char* telephon;

	char* strasse;
	char* hausnummer;

	int plz;
	char* ort;

	int ip; 

} ;

struct knoten{
	struct adresse adresse; /* void* daten; */
	struct knoten* next;
} ;

/* Einlesen eines Datensatzes in neue Karteikarte */
struct adresse* einlesen(){ 
	struct adresse* neueadresse;

	/* Speicher fuer Adresskarte reservieren */
	neueadresse=(struct adresse*) malloc(sizeof(struct adresse));
	
	printf("Eingabe (Nach-)Name: "); /*Ausgabe des Promptes*/
	neueadresse->name=malloc(256); /*Speicher reservieren*/
	/*Einlesen*/
	scanf("%s",neueadresse->name); /*alternative: (*neueadresse).name*/
	while (getchar() != '\n'); /*Speicher fuer naechsten scanf-Aufruf leeren*/

	printf("Eingabe Vorname: ");
	neueadresse->vorname=malloc(512);
	scanf("%s",neueadresse->vorname); 
	while (getchar() != '\n');

	printf("Eingabe Telephon: ");
	neueadresse->telephon=malloc(128);
	scanf("%s",neueadresse->telephon); 
	while (getchar() != '\n');

	printf("Eingabe Strasse: ");
	neueadresse->strasse=malloc(512);
	scanf("%s",neueadresse->strasse); 
	while (getchar() != '\n');

	printf("Eingabe Hausnummer: ");
	neueadresse->hausnummer=malloc(16);
	scanf("%s",neueadresse->hausnummer); 
	while (getchar() != '\n');

	printf("Eingabe Ort: ");
	neueadresse->ort=malloc(512);
	scanf("%s",neueadresse->ort); 
	while (getchar() != '\n');

	printf("Eingabe PLZ: ");
	scanf("%d",&neueadresse->plz); 
	while (getchar() != '\n');

/*	printf("Eingabe IP: ");
	scanf("%x",neueadresse->ip); */

	return neueadresse; /* Rueckgabe der erstellten Adresskarte */
}


void ausgabe(struct adresse* x){ /* Ausgabe: Trivial */
	printf("Name: %s\n",x->name); 
	printf("Vorname: %s\n",x->vorname); 
	printf("Telephon: %s\n",x->telephon); 
	printf("Strasse: %s\n",x->strasse); 
	printf("Hausnummer: %s\n",x->hausnummer); 
	printf("PLZ/Ort: %d %s \n",x->plz, x->ort); 
}

void menue(struct adresse** adrdb){
	int k; /* Kommando */
	int i;
	struct adresse ** iadrdb;
	k=0x00;
	while(k!='q'){
		printf("Bitte Kommando eingeben:\n\
i: Einlesen, a: Alle Datensaetze Ausgeben, l: Datensatz loeschen, \
b: bearbeiten, m: mehrere einlesen, q: beenden\n");
		k=getchar();
		while(getchar()!='\n');
		switch(k){
			case 'i':
				adrdb[0]=einlesen();
				break;
			case 'm': 
			/*	*adrdb=einlesen(); 
				ausgabe(*adrdb); 

				*(adrdb+1)=einlesen(); 
				ausgabe(*(adrdb+1)); 
				*/

				printf("Bitte Anzahl der Eingaben eingeben:");
				scanf("%d",&i);
				/* TODO: Eingabe pruefen (max. 16) */

				/* Schleife ueber i Eintraege (von i-1 bis 0)
				 * Vorsicht: Wir zaehlen hier rueckwaerts! */ 
				for(i--; i>=0 ;i--){ 
					adrdb[i]=einlesen();  /* i-ten Eintrag einlesen */
				}
				break;
			case 'a':
				/* Ausgabe */
				iadrdb=adrdb; /* Pointer auf Adressdatenbank duplizieren */
				/* So koennen wir die Adressdatenbank behalten, und dennoch die
				 * Speicheradresse des aktuellen Eintrages verwenden */
	
				/* Schleife bis der Zeiger auf die "Karteikarte" NULL ist. */
				while((*iadrdb)!=NULL){ 
					ausgabe(*iadrdb); /* Ausgeben */
					iadrdb++; /* Naechster Eintrag */
				}
				break;
			case 'l':
				printf("Feature in der Premium-Version");
				break;
			case 'b':
				printf("Fuer dieses Feature bitte folgendes DLC installiern.");
				break;
			case 'q':
			case '\n':
				break;
			default:
				printf("Lern lesen du Penner!");
		}
	}
}

int main(int argc, char** argv){
	struct adresse* adrdb[16];  /*adressdatenbank*/

	memset(adrdb,(int) NULL,16*sizeof(struct adresse*));

/*	Alternative Lösung: Dynamische Speicherreservierung! 

	struct adresse** adrdb; 
	adrdb=(struct adresse**) malloc(16*sizeof(struct adresse*));
	 
*/
	menue(adrdb);

	

	return 0;
}

/*

   Bitte Kommando eingeben:
i: Einlesen, a: Alle Datensaetze Ausgeben, l: Datensatz loeschen, b: bearbeiten.

	i
	Abfrage neuer Datensatz
	



   */



