#include<stdio.h>
#include<stdlib.h>
#include<string.h>

/* http://www.devtal.de/~thoto/ckurs/addressbuch3.tar.gz */

int aktuelleid=0;

struct adresse{ /* Struktur aller Adressen: "Karteikarte" */
	char* vorname;
	char* name;

	char* telephon;

	char* strasse;
	char* hausnummer;

	int plz;
	char* ort;

	int ip; 
} ;

struct knoten{
	struct adresse adresse; /* void* daten; */
	int id;
	struct knoten* next;
} ;

/* Einlesen eines Datensatzes in neue Karteikarte */
struct knoten* einlesen(){ 
	struct knoten* neueadresse;

	/* Speicher fuer Adresskarte reservieren */
	neueadresse=(struct knoten*) malloc(sizeof(struct knoten));
	
	printf("Eingabe (Nach-)Name: "); /*Ausgabe des Promptes*/
	(neueadresse->adresse).name=malloc(256); /*Speicher reservieren*/
	/*Einlesen*/
	scanf("%s",neueadresse->adresse.name); /*alternative: (*neueadresse).name*/
	while (getchar() != '\n'); /*Speicher fuer naechsten scanf-Aufruf leeren*/

	printf("Eingabe Vorname: ");
	neueadresse->adresse.vorname=malloc(512);
	scanf("%s",neueadresse->adresse.vorname); 
	while (getchar() != '\n');

	printf("Eingabe Telephon: ");
	neueadresse->adresse.telephon=malloc(128);
	scanf("%s",neueadresse->adresse.telephon); 
	while (getchar() != '\n');

	printf("Eingabe Strasse: ");
	neueadresse->adresse.strasse=malloc(512);
	scanf("%s",neueadresse->adresse.strasse); 
	while (getchar() != '\n');

	printf("Eingabe Hausnummer: ");
	neueadresse->adresse.hausnummer=malloc(16);
	scanf("%s",neueadresse->adresse.hausnummer); 
	while (getchar() != '\n');

	printf("Eingabe Ort: ");
	neueadresse->adresse.ort=malloc(512);
	scanf("%s",neueadresse->adresse.ort); 
	while (getchar() != '\n');

	printf("Eingabe PLZ: ");
	scanf("%d",&neueadresse->adresse.plz); 
	while (getchar() != '\n');

/*	printf("Eingabe IP: ");
	scanf("%x",neueadresse->ip); */

	neueadresse->id=aktuelleid++;
	return neueadresse; /* Rueckgabe der erstellten Adresskarte */
}


void ausgabe(struct adresse* x){ /* Ausgabe: Trivial */
	printf("Name: %s\n",x->name); 
	printf("Vorname: %s\n",x->vorname); 
	printf("Telephon: %s\n",x->telephon); 
	printf("Strasse: %s\n",x->strasse); 
	printf("Hausnummer: %s\n",x->hausnummer); 
	printf("PLZ/Ort: %d %s \n",x->plz, x->ort); 
}

void ausgabemitid(struct knoten* adrdb){
	while(adrdb!=0x00){
		printf("\t%d: %s %s\n", adrdb->id, 
				adrdb->adresse.vorname, adrdb->adresse.name);
		adrdb=adrdb->next;
	}
}

void menue(struct knoten* adrdb){
	int k; /* Kommando */
	struct knoten* iadrdb; 
	k=0x00;
	while(k!='q'){
		printf("Bitte Kommando eingeben:\n\
i: Einlesen, a: Alle Datensaetze Ausgeben, l: Datensatz loeschen, \
b: bearbeiten, m: mehrere einlesen, q: beenden\n");
		k=getchar();
		while(getchar()!='\n');
		switch(k){
			case 'i':
				iadrdb=adrdb;
				/* noch keine Adresse vorhanden */
				if(iadrdb==0x00) adrdb=einlesen(); 
				else {
					while(iadrdb->next!=0x00) iadrdb=iadrdb->next;
					iadrdb->next=einlesen();
				}
				break;
			case 'a':
				/* Ausgabe */
				iadrdb=adrdb; /* Pointer auf Adressdatenbank duplizieren */
				/* So koennen wir die Adressdatenbank behalten, und dennoch die
				 * Speicheradresse des aktuellen Eintrages verwenden */
	
				/* Schleife bis der Zeiger auf die "Karteikarte" NULL ist. */
				while(iadrdb!=0x00){ 
					ausgabe(&(iadrdb->adresse)); /* Ausgeben */
					iadrdb=iadrdb->next; /* Naechster Eintrag */
				}
				break;
			case 'l':
				printf("Feature in der Premium-Version. Vorschau: \n");
				ausgabemitid(adrdb);
				break;
			case 'b':
				printf("Fuer dieses Feature bitte folgendes DLC installiern.");
				break;
			case 'q':
			case '\n':
				break;
			default:
				printf("Lern lesen du Penner!");
		}
	}
}

int main(int argc, char** argv){
	struct knoten* adrdb;  /*adressdatenbank*/

	adrdb=0x00;

	menue(adrdb);

	return 0;
}
