#include<stdio.h>
#include<stdlib.h>
#include<string.h>

/* http://www.devtal.de/~thoto/ckurs/addressbuch3.tar.gz */

int aktuelleid=0;

struct adresse{ /* Struktur aller Adressen: "Karteikarte" */
	char* vorname;
	char* name;

	char* telephon;

	char* strasse;
	char* hausnummer;

	int plz;
	char* ort;

	int ip; 
} ;

struct knoten{
	struct adresse adresse; /* void* daten; */
	int id;
	struct knoten* next;
} ;

/* Einlesen eines Datensatzes in neue Karteikarte */
struct knoten* einlesen(){ 
	struct knoten* neueadresse;

	/* Speicher fuer Adresskarte reservieren */
	neueadresse=(struct knoten*) malloc(sizeof(struct knoten));
	
	printf("Eingabe (Nach-)Name: "); /*Ausgabe des Promptes*/
	(neueadresse->adresse).name=malloc(256); /*Speicher reservieren*/
	/*Einlesen*/
	scanf("%s",neueadresse->adresse.name); /*alternative: (*neueadresse).name*/
	while (getchar() != '\n'); /*Speicher fuer naechsten scanf-Aufruf leeren*/

	printf("Eingabe Vorname: ");
	neueadresse->adresse.vorname=malloc(512);
	scanf("%512s",neueadresse->adresse.vorname); 
	while (getchar() != '\n');

	printf("Eingabe Telephon: ");
	neueadresse->adresse.telephon=malloc(128);
	scanf("%128s",neueadresse->adresse.telephon); 
	while (getchar() != '\n');

	printf("Eingabe Strasse: ");
	neueadresse->adresse.strasse=malloc(512);
	scanf("%512s",neueadresse->adresse.strasse); 
	while (getchar() != '\n');

	printf("Eingabe Hausnummer: ");
	neueadresse->adresse.hausnummer=malloc(16);
	scanf("%16s",neueadresse->adresse.hausnummer); 
	while (getchar() != '\n');

	printf("Eingabe Ort: ");
	neueadresse->adresse.ort=malloc(512);
	scanf("%512s",neueadresse->adresse.ort); 
	while (getchar() != '\n');

	printf("Eingabe PLZ: ");
	scanf("%d",&neueadresse->adresse.plz); 
	while (getchar() != '\n');

/*	printf("Eingabe IP: ");
	scanf("%x",neueadresse->ip); */

	neueadresse->id=aktuelleid++;
	neueadresse->next=0x00;
	return neueadresse; /* Rueckgabe der erstellten Adresskarte */
}

/*struct knoten* knoten_entfernen(struct knoten* knoten){
	struct knoten* tempnext;
	tempnext=knoten->next;
	free(knoten);
	return tempnext;
}*/

void loeschen(struct knoten** padrdb, int id){
	struct knoten* adrdb=*padrdb;
	struct knoten* tempnext;

	if(id>=aktuelleid){ /* id > Maximalwert */
		printf("Datensatz mit ID %d nicht vorhanden.\n", id); /*404*/
		return;
	} 
	if(adrdb==0x00){ /* erstes Element existiert nicht */
		printf("Keine Datensaetze vorhanden.\n");
		return;
	}
	if(adrdb->id==id){ /* erstes Element = id */ 
		tempnext=adrdb->next; /* Next retten */
		free(adrdb);
		(*padrdb)=tempnext;
		printf("Datensatz mit ID %d geloescht.\n", id); 
	}else {
		while(adrdb->next!=0x00){ /* Element -> next existiert */
			if(adrdb->next->id==id){ /* ID d. naechst. Elem. = ges. ID? */
				/* loeschen */
				tempnext=adrdb->next->next; /* Next retten */
				free(adrdb->next);
				adrdb->next=tempnext;
				printf("Datensatz mit ID %d geloescht.\n", id); 
				return;
			}else{ /* naechstes Element */
				adrdb=adrdb->next; /* Schleifenerhoehung */
			}
		}

	}
}

void ausgabe(struct adresse* x){ /* Ausgabe: Trivial */
	printf("Name:      %s\n",x->name); 
	printf("Vorname:   \t%s\n",x->vorname); 
	printf("Telephon:  \t%s\n",x->telephon); 
	printf("Strasse:   \t%s\n",x->strasse); 
	printf("Hausnummer:\t%s\n",x->hausnummer); 
	printf("PLZ/Ort:   \t%d %s \n\n",x->plz, x->ort); 
}

void ausgabemitid(struct knoten* adrdb){
	/* for(initialisierung;gueltigkeitspruefung;mutation) */
	for(;adrdb!=0x00; adrdb=adrdb->next){
		printf("\t%d:\t%s\t%s\n", adrdb->id, 
				adrdb->adresse.vorname, adrdb->adresse.name);
	}
}


char* stringescape(char* peingabe){
	char* eingabe, *ausgabe, *rausgabe;
	int laenge;

	eingabe=peingabe;
	laenge=0;

	/* ermittle Laenge der escapten Zeichenkette */
	while((*eingabe)!='\0'){ 
		switch(*eingabe){
			case '\\': /* Sonderzeichen: Laenge um zwei erhoehen. */
			case '"':
				laenge+=2;
				break;
			default:
				laenge++;
		}
		eingabe++; /* Zaehler erhoehen -> Position auf naechstes Zeichen */
	}
	
	eingabe=peingabe; /* Zeiger zuruecksetzen */
	ausgabe=(char*) malloc(laenge+1); /* Speicher reservieren */
	rausgabe=ausgabe;
	
	while((*eingabe)!='\0'){
		/* Sonderzeichen: Backslash einfuegen */
		if(*eingabe=='\\'||*eingabe=='"'){
			*ausgabe='\\';
			ausgabe++;
		}
		
		/* Zeichen kopieren */
		*ausgabe=*eingabe;
		ausgabe++;
		eingabe++; /* Zaehler erhoehen -> Position auf naechstes Zeichen */
	}
	*ausgabe=0x00; /* Ende der Zeichenkette */
	
	return rausgabe; 
}

void dateiausgabe(struct adresse* x, FILE* fd){ /* Ausgabe: Trivial */
	char* wname=stringescape(x->name);
	char* wvorname=stringescape(x->vorname);
	char* wtelephon=stringescape(x->telephon);
	char* wstrasse=stringescape(x->strasse);
	char* whausnummer=stringescape(x->hausnummer);
	char* wort=stringescape(x->ort);

	fprintf(fd,"\"%s\";\"%s\";",wname,wvorname); 
	fprintf(fd,"\"%s\";",wtelephon); 
	fprintf(fd,"\"%s\";\"%s\";",wstrasse,whausnummer); 
	fprintf(fd,"%d;\"%s\"\n",x->plz, wort); 
	
	free(wname);
	free(wvorname);
	free(wtelephon);
	free(wstrasse);
	free(whausnummer);
	free(wort);
}

void menue(struct knoten* adrdb){
	int k; /* Kommando */
	int id;
	FILE* fd;
	struct knoten* iadrdb; 
	k=0x00;
	while(k!='q'){
		printf("Bitte Kommando eingeben:\n\
i: Einlesen, a: Alle Datensaetze Ausgeben, l: Datensatz loeschen, \
b: bearbeiten, m: mehrere einlesen, s: auf Platte schreiben q: beenden\n");
		k=getchar();
		while(getchar()!='\n');
		switch(k){
			case 'i':
				iadrdb=adrdb;
				/* noch keine Adresse vorhanden */
				if(iadrdb==0x00) adrdb=einlesen(); 
				else {
					while((*iadrdb).next!=0x00) iadrdb=iadrdb->next;
					iadrdb->next=einlesen();
				}
				break;
			case 'a':
				/* Ausgabe */
				iadrdb=adrdb; /* Pointer auf Adressdatenbank duplizieren */
				/* So koennen wir die Adressdatenbank behalten, und dennoch die
				 * Speicheradresse des aktuellen Eintrages verwenden */
	
				/* Schleife bis der Zeiger auf die "Karteikarte" NULL ist. */
				while(iadrdb!=0x00){ 
					ausgabe(&(iadrdb->adresse)); /* Ausgeben */
					iadrdb=iadrdb->next; /* Naechster Eintrag */
				}
				break;
			case 'l':
				ausgabemitid(adrdb);
				printf("Bitte ID eingeben: ");
				scanf("%d", &id);
				while(getchar()!='\n');
				loeschen(&adrdb,id);
				break;
			case 'b':
				printf("Fuer dieses Feature bitte folgendes DLC installiern.");
				break;
			case 's':
				fd=fopen("datenbank.csv", "w+");
				iadrdb=adrdb; /* Pointer auf Adressdatenbank duplizieren */
				while(iadrdb!=0x00){ 
					dateiausgabe(&(iadrdb->adresse),fd); /* Ausgeben */
					iadrdb=iadrdb->next; /* Naechster Eintrag */
				}
				fclose(fd);
				break;
			case 'q':
			case '\n':
				break;
			default:
				printf("Lern lesen du Penner!");
		}
	}
}

int main(int argc, char** argv){
	struct knoten* adrdb;  /*adressdatenbank*/

	adrdb=0x00;

	menue(adrdb);

	return 0;
}
