#include"parser.h"
#include"scanner.h"
#include<stdlib.h>

struct knoten* parse_file(FILE* fd){
	char* buf;
	int tmp;
	int mem;
	struct symbol sym;
	struct knoten* adrdb,* thisknot, *prevknot;

	enum { z_daten, z_zahl, z_igno, z_bsli, z_bsl} modus;

	enum { ins_vorname, ins_name, ins_telephon, ins_strasse, ins_hausnummer, 
			ins_plz, ins_ort } schreibziel; 

	modus=z_daten; /* Modi intialisieren */
	schreibziel=ins_name;

	mem=256; /* Speichergroesse */
	thisknot=(struct knoten*) malloc(sizeof(struct knoten)); /* Datensatz  */
	thisknot->adresse.name=(char*) malloc(mem);              /* anlegen    */
	buf=thisknot->adresse.name; /* Schreibzeiger */

	adrdb=thisknot; /* Initialisierung: Erster Eintrag */ 
	prevknot=NULL;

	while((sym=scan_sym(fd)).sym_typ!=s_eof){
		switch(modus){
			case z_daten:  
				if(sym.sym_typ==s_anf) 
					modus=z_igno;
				else if(sym.sym_typ==s_sem){
					*buf='\0';
					if(schreibziel==ins_name){
						schreibziel=ins_vorname;
						mem=512; /* Speichergroesse */
						thisknot->adresse.vorname=(char*) malloc(mem);
						buf=thisknot->adresse.vorname; /* Schreibzeiger */
					}else if(schreibziel==ins_vorname){
						schreibziel=ins_telephon;
						mem=128; /* Speichergroesse */
						thisknot->adresse.telephon=(char*) malloc(mem);
						buf=thisknot->adresse.telephon; /* Schreibzeiger */
					}else if(schreibziel==ins_telephon){
						schreibziel=ins_strasse;
						mem=512; /* Speichergroesse */
						thisknot->adresse.strasse=(char*) malloc(mem);
						buf=thisknot->adresse.strasse; /* Schreibzeiger */
					}else if(schreibziel==ins_strasse){
						schreibziel=ins_hausnummer;
						mem=16; /* Speichergroesse */
						thisknot->adresse.hausnummer=(char*) malloc(mem);
						buf=thisknot->adresse.hausnummer; /* Schreibzeiger */
					}else if(schreibziel==ins_hausnummer){ schreibziel=ins_plz;
						thisknot->adresse.plz=tmp=0;
						modus=z_zahl;
					}else { 
						fprintf(stderr, "Parserfehler, Zeichen:%c\n", sym.code);
						return 0; 
					}
				} else if(sym.sym_typ==s_bsl) 
					modus=z_bsl;
				else if(sym.sym_typ==s_brk){ 
					if(schreibziel!=ins_ort) {
						fprintf(stderr, "Ungueltige CSV-Datei\n");
						return 0x00;
					}
				   	modus=z_daten;
					*buf='\0';                       /* Datensatz anlegen */
					prevknot=thisknot;
					thisknot=(struct knoten*) malloc(sizeof(struct knoten)); 
					thisknot->adresse.name=(char*) malloc(512); 	
					mem=512; /* Speichergroesse */
					buf=thisknot->adresse.name; /* Schreibzeiger */
					prevknot->next=thisknot; /* Verkettung */
					schreibziel=ins_name;
				} else if(sym.sym_typ==s_zif || sym.sym_typ==s_chr){
					*buf=sym.code;
					buf++;
					mem--;
					if(mem==0x00){ fprintf(stderr, "Zu gross."); return 0;}
				} else {
					fprintf(stderr, "Unbekannter Modus.\n");
					return 0x00; /* Crash! */
				}
				break;
			case z_zahl:  
				if(sym.sym_typ==s_anf || sym.sym_typ==s_brk || 
						sym.sym_typ==s_bsl || sym.sym_typ==s_chr){
					fprintf(stderr, "Ungueltiges Zeichen fuer Zahl gelesen.\n");
					return 0;
				} else if(sym.sym_typ==s_sem){
					if(schreibziel==ins_plz){
						thisknot->adresse.plz=tmp;
						schreibziel=ins_ort;
						mem=512; /* Speichergroesse */
						thisknot->adresse.ort=(char*) malloc(mem);
						buf=thisknot->adresse.ort; /* Schreibzeiger */
						modus=z_daten;
					}else { 
						fprintf(stderr, "Parserfehler. Zeichen:%c\n", sym.code);
						return 0; 
					}
				} else if(sym.sym_typ==s_zif){
					tmp*=10;
					tmp+=sym.code-0x30;
				} else {
					fprintf(stderr, "Unbekannter Modus.\n");
					return 0x00; /* Crash! */
				}
				break;
			case z_igno:
				if(sym.sym_typ==s_anf){
					modus=z_daten;
				} else if(sym.sym_typ==s_sem || sym.sym_typ==s_brk || 
							sym.sym_typ==s_zif || sym.sym_typ==s_chr){
					*buf=sym.code;
					buf++;
					mem--;
					if(mem==0x00){ fprintf(stderr, "Zu gross."); return 0;}
				}else if(sym.sym_typ==s_bsl){
					modus=z_bsli;
				} else {
					fprintf(stderr, "Unbekanntes Symbol.\n");
					return 0x00; /* Crash! */
				}
				break;
			case z_bsli:
				if(sym.sym_typ!=s_eof){
					*buf=sym.code;
					buf++;
					mem--;
					if(mem==0x00){ fprintf(stderr, "Zu gross."); return 0;}
					modus=z_igno;
				}
				break;
			case z_bsl:
				if(sym.sym_typ!=s_eof){
					*buf=sym.code;
					buf++;
					mem--;
					if(mem==0x00){ fprintf(stderr, "Zu gross."); return 0;}
					modus=z_daten;
				}
				break;
		}
	}

	
	if(schreibziel==ins_name) {
		if(prevknot!=NULL) prevknot->next=NULL; 
	}else if(schreibziel==ins_ort) {
		thisknot->next=NULL;
	}
	return adrdb;
}

	
